<?php

use Codexpert\CoDesigner\Helper;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Text_Stroke;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

$widget = $args['this'];



$widget->start_controls_section(
    'progress_temp4_text',
    [
        'label'      => __( 'Heading Text', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_checkout_template' => 'template-4',
        ],
    ]
);
$widget->add_control(
    'progress_temp4_show_hide',
    [
        'label'         => __( 'Show/Hide Text', 'codesigner' ),
        'type'          => Controls_Manager::SWITCHER,
        'label_on'      => __( 'Show', 'codesigner' ),
        'label_off'     => __( 'Hide', 'codesigner' ),
        'return_value'  => 'yes',
        'default'       => 'yes',
    ]
);

$widget->add_control(
    'template4_billing_address_txt',
    [
        'label'         => __( 'Billing Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Billing Summary', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp4_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'template4_shipping_to_address_txt',
    [
        'label'         => __( 'Shipping to Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Ship to different address?', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp4_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'template4_shipping_address_txt',
    [
        'label'         => __( 'Shipping Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Shipping Summary', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp4_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'temp-4-order-notes',
    [
        'label'         => __( 'Order Notes', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order Notes(optional)', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp3_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'order_txt_temp4',
    [
        'label'         => __( 'Order Info Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order Summary', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp4_show_hide' => 'yes'
        ],
    ]
);
$widget->add_control(
    'payment_txt_temp4',
    [
        'label'         => __( 'Payment Info Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Payment Methods', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
        'condition'     => [
            'progress_temp4_show_hide' => 'yes'
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_temp4_order_btn_text',
    [
        'label'      => __( 'Order Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_checkout_template' => 'template-4',
        ],
    ]
);
$widget->add_control(
    'order_btn_txt_temp4',
    [
        'label'         => __( 'Order Button', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Place Order', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->end_controls_section();
/**
 * template-4 background and border colors
 */

 $widget->start_controls_section(
    'template4_billing_heading',
    [
        'label'      => __( 'Checkout Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-4',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template4_heading_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-address-container h3',
    ]
);
$widget->add_control(
    'template4_heading_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-address-container h3' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();


$widget->start_controls_section(
    'template4_coupon_form',
    [
        'label'      => __( 'Coupon Form', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-4',
        ],
    ]
);
$widget->start_controls_tabs(
    'template4_coupon_form_control'
);
$widget->start_controls_tab(
    'template4_coupon_form_text_tab',
    [
        'label' => esc_html__( 'Text', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template4_coupon_form_typography',
        'selector'  => '{{WRAPPER}} #cd-coupon-form1 .woocommerce-info,
                        {{WRAPPER}} #cd-coupon-main p ',
    ]
);
$widget->add_control(
    'template4_coupon_form_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-form1 .woocommerce-info' => 'color: {{VALUE}} ',
            '{{WRAPPER}} #cd-coupon-main p'                 => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template4_coupon_form_input_color',
    [
        'label' 	=> esc_html__( 'Input Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-main .form-row input::placeholder' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template4_coupon_form_input_color_bg',
    [
        'label' 	=> esc_html__( 'Input background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-main .form-row input' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_responsive_control(
    'template4_coupon_form_input_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Input Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-coupon-main .form-row input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'template4_coupon_form_button_tab',
    [
        'label' => esc_html__( 'Button', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template4_coupon_form_button_typography',
        'selector'  => '{{WRAPPER}} #cd-coupon-form1 a.showcoupon,
                        {{WRAPPER}} #cd-coupon-main .form-row-last button',
    ]
);
$widget->add_control(
    'template4_coupon_form_button_color',
    [
        'label' 	=> esc_html__( 'Button Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-form1 a.showcoupon'           => 'color: {{VALUE}} ',
            '{{WRAPPER}} #cd-coupon-main .form-row-last button'  => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template4_coupon_form_button_background_color',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-coupon-form1 a.showcoupon'           => 'background: {{VALUE}} ',
            '{{WRAPPER}} #cd-coupon-main .form-row-last button'  => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_responsive_control(
    'template4_coupon_form_button_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-coupon-form1 a.showcoupon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} #cd-coupon-main .form-row-last button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'template4_billing_section',
    [
        'label'      => __( 'Billing & Shipping Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-4',
        ],
    ]
);
$widget->add_control(
    'template4_billing_background',
    [
        'label' 	=> esc_html__( 'Parent Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-address-container' => 'background: {{VALUE}} ',
            '{{WRAPPER}} .cd-checkout-template-4' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template4_billing_background_color',
    [
        'label' 	=> esc_html__( 'Billing Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-address' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_responsive_control(
    'template4_billing_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} .cd-checkout-address'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'template4_billing_section_shadow',
        'selector' 	=> '{{WRAPPER}} .cd-checkout-address',
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'template4_billing_form_style',
    [
        'label'      => __( 'Billing & Shipping Form', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-4',
        ],
    ]
);
$widget->start_controls_tabs(
    'template4_billing_form_design'
);
$widget->start_controls_tab(
    'template4_form_message_label',
    [
        'label' => esc_html__( 'Label', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'       => 'template4_form_message_typography',
        'selector'   => '{{WRAPPER}} #cd-billing-section .form-row label,
                         {{WRAPPER}} #cd-shipping-section .form-row label'     
    ]
);
$widget->add_control(
    'template4_form_message_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            ' {{WRAPPER}} #cd-billing-section .form-row label '    => 'color: {{VALUE}};' ,
            ' {{WRAPPER}} #cd-shipping-section .form-row label '   => 'color: {{VALUE}};'
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'template4_form_message_input',
    [
        'label' => esc_html__( 'Input', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template4_form_input_typography',
        'selector'  => '{{WRAPPER}} .woocommerce-input-wrapper input,
                        {{WRAPPER}} .woocommerce-input-wrapper select,
                        {{WRAPPER}} .woocommerce-input-wrapper select .select2-selection'

    ]
);
$widget->add_control(
    'template4_form_input_color',
    [
        'label'     => esc_html__( 'Placeholder Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce-input-wrapper input '            => 'color: {{VALUE}}',
            '{{WRAPPER}} .woocommerce-input-wrapper select '           => 'color: {{VALUE}}',
            '{{WRAPPER}} .woocommerce-input-wrapper input input:focus' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'template4_form_input_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-billing-section .form-row input'          => 'background: {{VALUE}}',
            '{{WRAPPER}} #cd-billing-section .form-row select'         => 'background: {{VALUE}}',
            '{{WRAPPER}} #cd-shipping-section .form-row input'         => 'background: {{VALUE}}',
            '{{WRAPPER}} #cd-shipping-section .form-row select'        => 'background: {{VALUE}}',
            '{{WRAPPER}} .woocommerce-js .select2-container--default .select2-selection--single .select2-selection__rendered' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'template4_form_input_box_shadow',
        'selector' 	=> '{{WRAPPER}} #cd-billing-section .form-row input, 
                        {{WRAPPER}} #cd-billing-section .form-row select,
                        {{WRAPPER}} #cd-shipping-section .form-row input,
                        {{WRAPPER}} #cd-shipping-section .form-row select' 
    ]
);
$widget->add_responsive_control(
    'template4_form_input_padding',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Padding', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} .woocommerce-input-wrapper input '  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .woocommerce-input-wrapper select ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_responsive_control(
    'template4_form_input_border_radius',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Input Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-billing-section .form-row input'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} #cd-shipping-section .form-row input'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};', 
            '{{WRAPPER}} #cd-billing-section .form-row select'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} #cd-shipping-section .form-row select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section (
    'template4_order_notes_label',
    [
        'label'      => __( 'Order Notes', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-4',
        ],
    ]
);
$widget->start_controls_tabs(
    'template4_order_notes_form_design'
);
$widget->start_controls_tab(
    'template4_order_notes_label_tab',
    [
        'label' => esc_html__( 'Label', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'       => 'template4_order_notes_typography',
        'selector'   => '{{WRAPPER}} .order-notes .form-row label '     
    ]
);
$widget->add_control(
    'template4_order_notes_label_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .order-notes .form-row label' => 'color: {{VALUE}};'
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'template4_order_notes_input_tab',
    [
        'label' => esc_html__( 'Input', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template4_order_notes_input_typography',
        'selector'  => '{{WRAPPER}} .order-notes .form-row textarea  '

    ]
);
$widget->add_control(
    'template4_order_notes_input_color_placeholder',
    [
        'label'     => esc_html__( 'Placeholder Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .order-notes textarea#order_comments::placeholder'   => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'template4_order_notes_input_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .order-notes .form-row textarea' => 'background: {{VALUE}}',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'template4_order_notes_input_box_shadow',
        'selector' 	=> ' {{WRAPPER}} .order-notes .form-row textarea ' 
    ]
);
$widget->add_responsive_control(
    'template4_order_notes_input_padding',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Padding', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} .order-notes .form-row textarea '   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();
$widget->start_controls_section(
    'cd_checkout_template4_ship_to_different',
    [
        'label'      => __( 'Ship to different input', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-4',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template4_ship_to_different_typography',
        'selector'  => '{{WRAPPER}} .different-address-shipping label',
    ]
);
$widget->add_control(
    'template4_ship_to_different_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .different-address-shipping label' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();
$widget->start_controls_section(
    'cd_checkout_template_4_order_container',
    [
        'label'      => __( 'Order Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-4',
        ],
    ]
);
$widget->add_control(
    'template4_order_section_heading',
    [
        'label' 	=> esc_html__( 'Order Heading Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-order-container h3' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template4_order_heading_typography',
        'selector'  => '{{WRAPPER}} .cd-checkout-order-container h3',
    ]
);
$widget->add_control(
    'template4_order_parent_bg',
    [
        'label' 	=> esc_html__( 'Parent Section Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-order-container' => 'background: {{VALUE}} ',
        ],
    ]
);

$widget->add_control(
    'template4_order_bg',
    [
        'label' 	=> esc_html__( 'Order Details Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-order' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template4_order_border_radius',
    [
        'label' 	=> esc_html__( 'Border Radius', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::DIMENSIONS,
        'selectors' => [
            '{{WRAPPER}} .cd-checkout-order' => 'border-radius:  {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'template4_order_section_parent_box_shadow',
        'selector' 	=> '{{WRAPPER}} .cd-checkout-order',
    ]
);
$widget->start_controls_tabs(
    'template4_product_text_control'
);
$widget->start_controls_tab(
    'template4_order_section_product_tab',
    [
        'label' => esc_html__( 'Product', 'codesigner-pro' ),
    ]
);
$widget->add_responsive_control(
    'template4_product_image_control',
    [
        'type'   => Controls_Manager::SLIDER,
        'label'  => esc_html__( 'Image Sizing', 'codesigner-pro' ),
        'range'  => [
            'px' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'devices'         => [ 'desktop', 'tablet', 'mobile' ],
        'desktop_default' => [
            'size' => 64,
            'unit' => 'px',
        ],
        'tablet_default' => [
            'size' => 48,
            'unit' => 'px',
        ],
        'mobile_default' => [
            'size' => 32,
            'unit' => 'px',
        ],
        'selectors' => [
            '{{WRAPPER}} .codesigner-cart-item-thumbnail img' => 'width: {{SIZE}}{{UNIT}};',
        ],
    ]
);
$widget->add_control(
    'template4_order_title_color',
    [
        'label' 	=> esc_html__( 'Product Section Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .codesigner-temp4-cart-item-wrap p'  => 'color: {{VALUE}} ',
            '{{WRAPPER}} .numberstyle-qty input[type=number]' => 'color: {{VALUE}} ',
            '{{WRAPPER}} .codesinger-cart-item-price bdi'     => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_order_typography',
        'selector'  => '{{WRAPPER}} .codesigner-temp4-cart-item-wrap p,
                        {{WRAPPER}} .numberstyle-qty input[type=number],
                        {{WRAPPER}} .codesinger-cart-item-price bdi',
    ]
);
$widget->add_control(
    'template4_increment_decrement_button_color',
    [
        'label' 	=> esc_html__( 'Increment & Decrement Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .numberstyle-qty .qty-btn'  => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template4_increment_decrement_button_border_color',
    [
        'label' 	=> esc_html__( 'Increment & Decrement Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .numberstyle-qty .qty-btn'  => 'border-color: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'template4_order_section_text_tab',
    [
        'label' => esc_html__( 'Text', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_order_text_typography',
        'selector'  => '{{WRAPPER}} #cd-checkout-tfoot th,
                        {{WRAPPER}} #cd-checkout-tfoot td',                  
    ]
);
$widget->add_control(
    'template4_order_text_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-checkout-tfoot th'  => 'color: {{VALUE}} ',
            '{{WRAPPER}} #cd-checkout-tfoot td'  => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template4_order_border_color',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .codesigner-single-cart-item'  => 'border-color: {{VALUE}} ',
            '{{WRAPPER}} tr.order-total th'             => 'border-color: {{VALUE}} !important',
            '{{WRAPPER}} tr.order-total td'             => 'border-color: {{VALUE}} !important',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'template4_payment_section',
    [
        'label'      => __( 'Payment Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-4',
        ],
    ]
);
$widget->add_control(
    'template4_payment_method_bg',
    [
        'label' 	=> esc_html__( 'Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #payment > ul.wc_payment_methods.payment_methods.methods' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'template4_order_payment_typography',
        'selector'  => '{{WRAPPER}} #add_payment_method #payment ul.payment_methods li,
                        {{WRAPPER}} .woocommerce-cart #payment ul.payment_methods li,
                        {{WRAPPER}} .woocommerce-checkout #payment ul.payment_methods li',                  
    ]
);
$widget->add_control(
    'template4_payment_section_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #add_payment_method #payment ul.payment_methods li'   => 'color: {{VALUE}} ',
            '{{WRAPPER}} .woocommerce-cart #payment ul.payment_methods li'     => 'color: {{VALUE}} ',
            '{{WRAPPER}} .woocommerce-checkout #payment ul.payment_methods li' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template4_payment_section_box_color',
    [
        'label' 	=> esc_html__( 'Box Text Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .wc_payment_method p'   => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'template4_payment_section_box_border_color',
    [
        'label' 	=> esc_html__( 'Box Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #payment div.payment_box'         => 'border-color: {{VALUE}} ',
            '{{WRAPPER}} #payment div.payment_box'         => 'border-color: {{VALUE}} ',
            '{{WRAPPER}} #payment div.payment_box::before' => 'border-bottom-color: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();
$widget->start_controls_section(
    'cd_checkout_template_4_submit_button',
    [
        'label'      => __( 'Place Order Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'template-4',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_button_typography',
        'selector'  => '{{WRAPPER}} button#place_order',
    ]
);
$widget->add_control(
    'cd_checkout_order_button_bg',
    [
        'label'     => esc_html__( 'Button Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} button#place_order' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'cd_checkout_order_button_text_color',
    [
        'label'     => esc_html__( 'Button Text Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} button#place_order' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();
